@extends('admin.template')
@section('icerik')


    {{ csrf_field() }}

    <div class="container-fluid">
    <div class="row">

        <div class="col-lg-12">
            <div class="card card-primary">
                <div class="card-body">

                    <div class="form-group ">
                        <table id="example" class="table table-bordered table-striped dataTable" role="grid" aria-describedby="example1_info">
                            <thead>
                                <th style="width: 5%">#</th>
                                <th style="width: 20%">Cari Hesap</th>
                                <th style="width: 20%">Servis No</th>
                                <th style="width: 8%">Fiş Tutarı</th>
                                <th style="width: 10%">İskonto</th>
                                <th style="width: 10%">Ödeme</th>
                                <th style="width: 10%">Tarih</th>
                            </thead>
                            <tbody>
                                @foreach ($tahsilatlar as $tahsilat)
                                <tr>
                                    <td >{{ $tahsilat->id }}</td>
                                    <td >{{ $tahsilat->cari->isim }}</td>
                                    <td >{{ $tahsilat->servis_fisi_id }}</td>
                                    <td >{{ $tahsilat->servis_fisi_tutar }}</td>
                                    <td >{{ $tahsilat->iskonto }}</td>
                                    <td >{{ $tahsilat->odeme_tutari }}</td>
                                    <td >{{ $tahsilat->created_at->format('d/m/Y') }}</td>


                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>

                </div>
            </div>
        </div>




  <!-- /.row -->
</div>
</form>

</div>
@endsection

@section('css')
  <!-- DataTables -->
  <link rel="stylesheet" href="/yonetim/plugins/datatables-bs4/css/dataTables.bootstrap4.css">
@endsection

@section('js')
<!-- DataTables -->
<script src="/yonetim/plugins/datatables/jquery.dataTables.js"></script>
<script src="/yonetim/plugins/datatables-bs4/js/dataTables.bootstrap4.js"></script>



<script>
    $(function () {

      $('#example').DataTable({
        "paging": true,
        "lengthChange": true,
        "searching": true,
        "ordering": true,
        "info": true,
        "autoWidth": false,
        "language":{
                        "sDecimal":        ",",
                        "sEmptyTable":     "Tabloda herhangi bir veri mevcut değil",
                        "sInfo":           "_TOTAL_ kayıttan _START_ - _END_ arasındaki kayıtlar gösteriliyor",
                        "sInfoEmpty":      "Kayıt yok",
                        "sInfoFiltered":   "(_MAX_ kayıt içerisinden bulunan)",
                        "sInfoPostFix":    "",
                        "sInfoThousands":  ".",
                        "sLengthMenu":     "Sayfada _MENU_ kayıt göster",
                        "sLoadingRecords": "Yükleniyor...",
                        "sProcessing":     "İşleniyor...",
                        "sSearch":         "Ara:",
                        "sZeroRecords":    "Eşleşen kayıt bulunamadı",
                        "oPaginate": {
                            "sFirst":    "İlk",
                            "sLast":     "Son",
                            "sNext":     "Sonraki",
                            "sPrevious": "Önceki"
                        },
                        "oAria": {
                            "sSortAscending":  ": artan sütun sıralamasını aktifleştir",
                            "sSortDescending": ": azalan sütun sıralamasını aktifleştir"
                        },
                        "select": {
                            "rows": {
                                "_": "%d kayıt seçildi",
                                "0": "",
                                "1": "1 kayıt seçildi"
                            }
                        }
                    }
      });
    });
  </script>



@endsection
