@extends('admin.template')
@section('icerik')

<form method="POST" action="{{ route('home.servis_fisi.kaydet')}}">
    {{ csrf_field() }}

    <div class="container-fluid">
    <div class="row">
        <div class="col-lg-6">
            <div class="card card-dark">
                <div class="card-header">
                    <h5 class="m-0">Müşteri Bilgileri</h5>
                </div>
                <div class="card-body">
                    <div class="form-group row">
                        <label class="col-sm-2">Cari İsmi (*)</label>
                        <div class="col-sm-10">
                            <div class="input-group">
                                <div class="custom-file">
                                    <select class="cari form-control select2bs4 select2-hidden-accessible" name="cari" id="cari" style="width: 100%;" data-select2-id="1" tabindex="-1" aria-hidden="true" required>
                                        <option value="">Seçiniz</option>
                                        @foreach ($cariler as $cari)
                                            <option
                                            value={{ $cari->id }}>{{ $cari->isim }}</option>
                                        @endforeach
                                      </select>
                                </div>
                                <div class="input-group-append">
                                    <button type="button" class="btn btn-success" data-toggle="modal" data-target="#create">
                                       +
                                      </button>
                                </div>
                              </div>
                              <br><br><br><br>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-lg-6">
            <div class="card card-danger">
                <div class="card-header">
                    <h5 class="m-0">Cihaz Bilgileri</h5>
                </div>
                <div class="card-body">
                    <div class="form-group row">
                        <label class="col-sm-3">Ürün/Marka/Model (*)</label>
                        <div class="col-sm-3">
                            <div class="input-group">
                                <div class="custom-file">
                                    <select name="urun" id="urun" class="form-control" required>
                                        <option value="">Ürün Seçiniz</option>
                                        @foreach ($urunler as $urun)
                                            <option
                                            value={{ $urun->id }}>{{ $urun->isim }}</option>
                                        @endforeach
                                      </select>
                                </div>
                                <div class="input-group-append">
                                    <button type="button" class="btn btn-success" data-toggle="modal" data-target="#urunekle">
                                       +
                                      </button>
                                </div>
                              </div>

                        </div>
                        <div class="col-sm-3">
                            <div class="input-group input-group">
                                <select name="marka" id="marka" class="form-control" required>
                                    <option value="">Marka Seçiniz</option>
                                    @foreach ($markalar as $marka)
                                        <option
                                        value={{ $marka->id }}>{{ $marka->isim }}</option>
                                    @endforeach
                                </select>
                                <span class="input-group-append">
                                    <button type="button" class="btn btn-success" data-toggle="modal" data-target="#markaekle">
                                        +
                                       </button>
                                </span>
                              </div>
                        </div>
                        <div class="col-sm-3">
                            <input type="text" name="model" class="form-control" name="model" placeholder="Model" value="" >
                        </div>
                    </div>

                    <div class="form-group row">
                        <label class="col-sm-3">Seri No / IMEI (*)</label>
                        <div class="col-sm-9">
                            <input type="text" class="form-control" name="seri" placeholder="Seri No" value="" required>
                        </div>
                    </div>

                    <div class="form-group row">
                        <label class="col-sm-3">Garanti Durumu (*)</label>
                        <div class="col-sm-9">
                            <select name="garanti" class="form-control fill" required>

                                <option value="VAR">Garanti Var</option>
                                <option value="YOK" selected >Garanti Yok</option>
                            </select>
                        </div>
                    </div>

                </div>
            </div>
            </div>
            <div class="col-lg-12">
                <div class="card card-warning">
                    <div class="card-header">
                        <h5 style="color:white" class="m-0">Cihaz Durumu</h5>
                    </div>
                    <div class="card-body">
                        <div class="form-group row">
                            <div class="col-sm-4">
                                <textarea class="form-control" name="ariza" id="ariza" cols="30" rows="2" placeholder="Bildirilen Arıza (*)" required></textarea>

                            </div>
                            <div class="col-sm-4">
                                <textarea class="form-control" name="birliktegelen" id="birliktegelen" cols="30" rows="2" placeholder="Birlikte Gelenler" ></textarea>

                            </div>
                            <div class="col-sm-4">
                                <textarea class="form-control" name="aciklama" id="aciklama" cols="30" rows="2" placeholder="Açıklama"></textarea>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-6">
                <div class="card card-primary">
                    <div class="card-header">
                        <h5 class="m-0">Servis Durumu (*)</h5>
                    </div>
                    <div class="card-body">
                        <div class="form-group row">
                            <select name="durum" class="form-control" required>
                                <option  value="">Seçiniz</option>
                                @foreach ($durumlar as $durum)
                                                <option @if ($durum->id == 1 )
                                                    selected
                                                @endif
                                                value={{ $durum->id }}>{{ $durum->isim }}</option>
                                            @endforeach
                                          </select>
                            </select>
                            <br><br>
                            <textarea class="form-control" name="durum_aciklama" id=""  rows="3" placeholder="Servis Durumu Açıklaması"></textarea>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-6" >
                <div class="card card-info">
                    <div class="card-header">
                        <h5 class="m-0">Görev Ata</h5>
                    </div>
                    <div class="card-body">
                        <div class="form-group row">
                            <select name="personel" id="personel" class="personel form-control">

                                <option value="">Personel Seçiniz</option>
                                @foreach ($personeller as $personel)
                                    <option
                                    value={{ $personel->id }}>{{ $personel->name }}</option>
                                @endforeach
                              </select>
                              <br><br><br><br><br>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-body">
                        <button type="submit" name="ekle" class="btn btn-success btn-block">EKLE</button>
                    </div>
                </div>
            </div>
        </div>
  <!-- /.row -->
</div>
</form>
{{-- Modal Cari Ekle --}}
<div id="create" class="modal fade" role="dialog">
    <div class="modal-dialog modal-lg" role="document">
      <div class="modal-content">
        <div class="modal-body">
          <form class="form-horizontal" role="form">
            <div class="row">

            <div class="col-lg-12">
                <div class="form-group row add">
                    <label class="control-label" for="title">Ad Soyad / Ünvan :</label>
                    <input type="text" class="form-control" id="isim" name="isim"  required>
                </div>
            </div>

            <div class="col-lg-6">
                <div class="form-group row add">
                    <label class="control-label" for="title">Cep Telefonu :</label>
                    <input type="text" class="form-control" id="" name="telefon"  required>
                </div>
            </div>
            <div class="col-lg-6">
                <div class="form-group row add">
                    <label class="control-label" for="title">Email :</label>
                    <input type="text" class="form-control" id="" name="email"  >
                </div>
            </div>


            <div class="col-lg-12">
                <div class="form-group row add">
                    <label class="control-label" for="title">Adres :</label>
             <textarea name="adres" class="form-control" id="" ></textarea>
                </div>
            </div>

            <div class="col-lg-6">
                <div class="form-group row add">
                    <label class="control-label" for="title">İl :</label>
                    <input type="text" class="form-control" id="" name="il"  >
                </div>
            </div>
            <div class="col-lg-6">
                <div class="form-group row add">
                    <label class="control-label" for="title">İlçe :</label>
                    <input type="text" class="form-control" id="" name="ilce"  >
                </div>
            </div>
        </div>
          </form>
        </div>
            <div class="modal-footer">
              <button class="btn btn-success" type="submit" id="add">
                <span class="glyphicon glyphicon-plus"></span>Ekle
              </button>
              <button class="btn btn-danger" type="button" data-dismiss="modal">
                <span class="glyphicon glyphicon-remobe"></span>Kapat
              </button>
            </div>
      </div>
    </div>
  </div>
  {{-- Modal Cari Ekle --}}
  {{-- Modal Ürün Ekle --}}
  <div id="urunekle" class="modal fade" role="dialog">
    <div class="modal-dialog">
      <div class="modal-content">
        <div class="modal-body">
          <form class="form-horizontal" role="form">
            <div class="form-group row add">
              <label class="control-label col-sm-3" for="title"><b>Ürün Başlığı :</b></label>
              <div class="col-sm-10">
                <input type="text" class="form-control" id="isimurun" name="isimurun"
                 required>
              </div>
            </div>
          </form>
        </div>
            <div class="modal-footer">
              <button class="btn btn-success" type="submit" id="addurun">
                <span class="glyphicon glyphicon-plus"></span>+ Ekle
              </button>
              <button class="btn btn-danger" type="button" data-dismiss="modal">
                <span class="glyphicon glyphicon-remobe"></span>Kapat
              </button>
            </div>
      </div>
    </div>
  </div>
    {{-- Modal Ürün Ekle --}}
    {{-- Modal Marka Ekle --}}
  <div id="markaekle" class="modal fade" role="dialog">
    <div class="modal-dialog">
      <div class="modal-content">
        <div class="modal-body">
          <form class="form-horizontal" role="form">
            <div class="form-group row add">
              <label class="control-label col-sm-3" for="title"><b>Marka Başlığı :</b></label>
              <div class="col-sm-10">
                <input type="text" class="form-control" id="isimmarka" name="isimmarka"
                 required>
              </div>
            </div>
          </form>
        </div>
            <div class="modal-footer">
              <button class="btn btn-success" type="submit" id="addmarka">
                <span class="glyphicon glyphicon-plus"></span>+ Ekle
              </button>
              <button class="btn btn-danger" type="button" data-dismiss="modal">
                <span class="glyphicon glyphicon-remobe"></span>Kapat
              </button>
            </div>
      </div>
    </div>
  </div>
    {{-- Modal Marka Ekle --}}
</div>
@endsection

@section('css')


@endsection

@section('js')

<!-- Cari Ekle Script -->
<script type="text/javascript">
    $(document).ready(function(){
		$("#add").click(function() {
            var div=$(this).parent();
            var op=" ";
			$.ajax({
				type:'get',
				url:'{!!URL::to('cariekle')!!}',
				data: {
        'isim': $('input[name=isim]').val(),
        'telefon': $('input[name=telefon]').val(),
        'email': $('input[name=email]').val(),
        'adres': $('textarea[name=adres]').val(),
        'il': $('input[name=il]').val(),
        'ilce': $('input[name=ilce]').val()
      },
				success:function(data){
                    $('#create').modal('hide');
                    $('#cari').empty();
                    $('#cari').append('<option value="">Seçiniz</option>');
                    $.each(data,function(index,cari){
                        $('#cari').append('<option selected value="'+cari.id+'">'+cari.isim+'</option>');
                    })
				},
				error:function(){

				}
			});
		});
	});
</script>
<!-- Cari Ekle Script -->
<!-- Ürün Ekle Script -->
<script type="text/javascript">
    $(document).ready(function(){
		$("#addurun").click(function() {
            var div=$(this).parent();
            var op=" ";
			$.ajax({
				type:'get',
				url:'{!!URL::to('urunekleservis')!!}',
				data: {
        'isimurun': $('input[name=isimurun]').val()
      },
				success:function(data){
                    console.log(data);
                    $('#urunekle').modal('hide');
                    $('#urun').empty();
                    $('#urun').append('<option value="">Seçiniz</option>');
                    $.each(data,function(index,urun){
                        $('#urun').append('<option selected value="'+urun.id+'">'+urun.isim+'</option>');
                    })
				},
				error:function(){

				}
			});
		});
	});
</script>
<!-- Ürün Ekle Script -->
<!-- Marka Ekle Script -->
<script type="text/javascript">
    $(document).ready(function(){
		$("#addmarka").click(function() {
            var div=$(this).parent();
            var op=" ";
			$.ajax({
				type:'get',
				url:'{!!URL::to('markaekleservis')!!}',
				data: {
        'isimmarka': $('input[name=isimmarka]').val()
      },
				success:function(data){
                    console.log(data);
                    $('#markaekle').modal('hide');
                    $('#marka').empty();
                    $('#marka').append('<option value="">Seçiniz</option>');
                    $.each(data,function(index,marka){
                        $('#marka').append('<option selected value="'+marka.id+'">'+marka.isim+'</option>');
                    })
				},
				error:function(){

				}
			});
		});
	});
</script>
<!-- Marka Ekle Script -->




<!-- Bootstrap Switch -->
<script src="/yonetim/plugins/bootstrap-switch/js/bootstrap-switch.min.js"></script>
@endsection
