<?php

use Illuminate\Support\Facades\Route;



Route::get('/', function () {
    return view('login');
});

Auth::routes();

Route::get('/home', 'HomeController@index')->name('home');

Route::get('/test', 'HomeController@test')->name('test');
Route::get('/print', 'PrintController@print')->name('print');

Route::group(['prefix' => 'home', 'middleware' => 'auth'], function () {

    Route::group(['prefix' => 'servis_fisi', 'middleware' => 'auth'], function () {
        Route::get('ekle', 'ServisFisiController@ekle')->name('home.servis_fisi.ekle');
        Route::get('listele', 'ServisFisiController@listele')->name('home.servis_fisi.listele');
        Route::post('kaydet', 'ServisFisiController@kaydet')->name('home.servis_fisi.kaydet');
        Route::get('duzenle/{id}', 'ServisFisiController@duzenle')->name('home.servis_fisi.duzenle');
        Route::patch('duzenle/{id}/duzenle', 'ServisFisiController@update')->name('home.servis_fisi.update');
        Route::get('yedekparcasil/{id}', 'ServisFisiController@yedekparcasil')->name('home.servis_fisi.yedekparcasil');
        Route::get('hizmetsil/{id}', 'ServisFisiController@hizmetsil')->name('home.servis_fisi.hizmetsil');
        Route::post('tahsilatyap', 'ServisFisiController@tahsilatyap')->name('home.servis_fisi.tahsilatyap');
        Route::get('filtrele/{id}', 'ServisFisiController@filtrele')->name('home.servis_fisi.filtrele');

    });

    Route::group(['prefix' => 'cari', 'middleware' => 'auth'], function () {

        Route::post('kaydet', 'CariController@kaydet')->name('home.cari.kaydet');
        Route::post('duzenle', 'CariController@duzenle')->name('home.cari.duzenle');
        Route::get('listele', 'CariController@listele')->name('home.cari.listele');
        Route::get('servis_fislerim/{id}', 'CariController@servis_fislerim')->name('home.cari.servis_fislerim');
    });

    Route::group(['prefix' => 'yedek_parcalar', 'middleware' => 'auth'], function () {
        Route::get('ekle', 'YedekParcalarController@ekle')->name('home.yedek_parcalar.ekle');
        Route::get('listele', 'YedekParcalarController@listele')->name('home.yedek_parcalar.listele');
        Route::post('kaydet', 'YedekParcalarController@kaydet')->name('home.yedek_parcalar.kaydet');
        Route::get('duzenle/{id}', 'YedekParcalarController@duzenle')->name('home.yedek_parcalar.duzenle');
        Route::patch('duzenle/{id}/duzenle', 'YedekParcalarController@update')->name('home.yedek_parcalar.update');
    });

    Route::group(['prefix' => 'hizmetler', 'middleware' => 'auth'], function () {
        Route::get('ekle', 'HizmetlerController@ekle')->name('home.hizmetler.ekle');
        Route::get('listele', 'HizmetlerController@listele')->name('home.hizmetler.listele');
        Route::post('kaydet', 'HizmetlerController@kaydet')->name('home.hizmetler.kaydet');
        Route::get('duzenle/{id}', 'HizmetlerController@duzenle')->name('home.hizmetler.duzenle');
        Route::patch('duzenle/{id}/duzenle', 'HizmetlerController@update')->name('home.hizmetler.update');
    });

    Route::group(['prefix' => 'kasa', 'middleware' => 'auth'], function () {

        Route::get('tahsilatlar', 'KasaController@tahsilatlar')->name('home.kasa.tahsilatlar');

    });


    Route::group(['prefix' => 'tanimlamalar', 'middleware' => 'auth'], function () {
        Route::get('durumlar', 'TanimlamalarController@durumlar')->name('home.tanimlamalar.durumlar');
        Route::get('markalar', 'TanimlamalarController@markalar')->name('home.tanimlamalar.markalar');
        Route::get('urunler', 'TanimlamalarController@urunler')->name('home.tanimlamalar.urunler');
        Route::get('sms_sablonlari', 'TanimlamalarController@sms_sablonlari')->name('home.tanimlamalar.sms_sablonlari');

        Route::post('durumkaydet', 'TanimlamalarController@durumkaydet')->name('home.tanimlamalar.durumkaydet');
        Route::post('markakaydet', 'TanimlamalarController@markakaydet')->name('home.tanimlamalar.markakaydet');
        Route::post('urunkaydet', 'TanimlamalarController@urunkaydet')->name('home.tanimlamalar.urunkaydet');
        Route::post('sms_sablon_kaydet', 'TanimlamalarController@sms_sablon_kaydet')->name('home.tanimlamalar.sms_sablon_kaydet');

        Route::post('markaduzenle', 'TanimlamalarController@markaduzenle')->name('home.tanimlamalar.markaduzenle');
        Route::post('urunduzenle', 'TanimlamalarController@urunduzenle')->name('home.tanimlamalar.urunduzenle');
        Route::post('durumduzenle', 'TanimlamalarController@durumduzenle')->name('home.tanimlamalar.durumduzenle');
        Route::post('sms_sablon_duzenle', 'TanimlamalarController@sms_sablon_duzenle')->name('home.tanimlamalar.sms_sablon_duzenle');

    });


    Route::group(['prefix' => 'form', 'middleware' => 'auth'], function () {
        Route::get('kabul/{id}', 'PrintController@kabul')->name('home.form.kabul');
        Route::get('teslim/{id}', 'PrintController@teslim')->name('home.form.teslim');
    });

    Route::group(['prefix' => 'sms', 'middleware' => 'auth'], function () {

        Route::post('gonder', 'SmsController@gonder')->name('home.sms.gonder');

    });

    Route::group(['prefix' => 'ayarlar', 'middleware' => 'auth'], function () {

        Route::get('firma', 'AyarlarController@firma')->name('home.ayarlar.firma');
        Route::post('firmaguncelle', 'AyarlarController@firmaguncelle')->name('home.ayarlar.firmaguncelle');

        Route::get('sms', 'AyarlarController@sms')->name('home.ayarlar.sms');
        Route::post('smsguncelle', 'AyarlarController@smsguncelle')->name('home.ayarlar.smsguncelle');


        Route::get('smssorgula', 'SmsController@smssorgula')->name('home.ayarlar.smssorgula');
        Route::patch('sifredegistir', 'AyarlarController@sifredegistir')->name('home.ayarlar.sifredegistir');


    });

    Route::group(['prefix' => 'search', 'middleware' => 'auth'], function () {

        Route::post('arama', 'SearchController@search')->name('home.search.arama');



    });

});

//  ----- AJAX  ----------- //
Route::get('/cariekle', 'CariController@cariekle');
Route::get('/urunekleservis', 'TanimlamalarController@urunekleservis');
Route::get('/markaekleservis', 'TanimlamalarController@markaekleservis');
Route::get('/fiyatgetir', 'YedekParcalarController@fiyatgetir');
Route::get('/hizmetfiyatgetir', 'HizmetlerController@hizmetfiyatgetir');
Route::get('/sms_sablon_getir', 'SmsController@sms_sablon_getir');



