<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">

<head>
    <meta charset="UTF-8">
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Takip Programı - Yönetim Paneli</title>

    <!-- CSRF Token -->
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <!-- Favicon-->
    <link rel="icon" href="/admin/favicon.ico" type="image/x-icon">

    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css?family=Roboto:400,700&subset=latin,cyrillic-ext" rel="stylesheet"
        type="text/css">
    <link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet" type="text/css">

    <!-- Bootstrap Core Css -->
    <link href="/admin/plugins/bootstrap/css/bootstrap.css" rel="stylesheet">

    <!-- Waves Effect Css -->
    <link href="/admin/plugins/node-waves/waves.css" rel="stylesheet" />

    <!-- Animation Css -->
    <link href="/admin/plugins/animate-css/animate.css" rel="stylesheet" />

    <!-- Custom Css -->
    <link href="/admin/css/style.css" rel="stylesheet">

    <!-- Bootstrap DatePicker Css -->
    <link href="/admin/plugins/bootstrap-datepicker/css/bootstrap-datepicker.css" rel="stylesheet" />

    <!-- Wait Me Css -->
    <link href="/admin/plugins/waitme/waitMe.css" rel="stylesheet" />

    
    <link rel="stylesheet" href="//code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css">
    <link rel="stylesheet" href="/resources/demos/style.css">



    <!-- AdminBSB Themes. You can choose a theme from css/themes instead of get all themes -->
    <link href="/admin/css/themes/all-themes.css" rel="stylesheet" />

    <link href="/admin/toastr.min.css" rel="stylesheet" />

    <link href="/admin/plugins/sweetalert/sweetalert.css" rel="stylesheet" />

    <?php echo $__env->yieldContent('css'); ?>
    <!-- Bootstrap Select Css -->
    <link href="/admin/plugins/bootstrap-select/css/bootstrap-select.css" rel="stylesheet" />

</head>

<body class="theme-red">





    <!-- Page Loader -->
    <div class="page-loader-wrapper">
        <div class="loader">
            <div class="preloader">
                <div class="spinner-layer pl-red">
                    <div class="circle-clipper left">
                        <div class="circle"></div>
                    </div>
                    <div class="circle-clipper right">
                        <div class="circle"></div>
                    </div>
                </div>
            </div>
            <p><?php echo e(config('app.name')); ?>. Lütfen Bekleyiniz...</p>
        </div>
    </div>
    <!-- #END# Page Loader -->
    <!-- Overlay For Sidebars -->
    <div class="overlay"></div>
    <!-- #END# Overlay For Sidebars -->
    <!-- Search Bar -->
    <div class="search-bar">
        <div class="search-icon">
            <i class="material-icons">search</i>
        </div>
        <input type="text" placeholder="NE ARIYORSUNUZ...">
        <div class="close-search">
            <i class="material-icons">close</i>
        </div>
    </div>
    <!-- #END# Search Bar -->
    <!-- Top Bar -->
    <nav class="navbar">
        <div class="container-fluid">
            <div class="navbar-header">
                <a href="javascript:void(0);" class="navbar-toggle collapsed" data-toggle="collapse"
                    data-target="#navbar-collapse" aria-expanded="false"></a>
                <a href="javascript:void(0);" class="bars"></a>
                <a class="navbar-brand" href="/"><b>Takip Programı - Yönetim Paneli</b></a>
                <a href="/" target="_blank" class="btn bg-cyan btn-circle waves-effect waves-circle waves-float">
                    <i class="material-icons">cloud_upload</i>
                </a>
            </div>

            <div class="collapse navbar-collapse" id="navbar-collapse">
                <ul class="nav navbar-nav navbar-right">
                    <!-- Call Search -->
                    
                    <!-- #END# Call Search -->
                    <!-- Notifications -->
                    <?php if(Auth::user()->yetki != "yazar"): ?>
                    <li class="dropdown">
                        
                        <ul class="dropdown-menu">
                            <li class="header">Bildirimler</li>
                            <li class="body">
                                <ul class="menu">
                                    
                            </li>
                        </ul>
                    </li>
                    <li class="footer">
                        <a href="javascript:void(0);">Tüm Bildirimleri Göster</a>
                    </li>
                </ul>
                </li>
                <?php endif; ?>
                <!-- #END# Notifications -->
                <!-- Tasks -->
                <li class="dropdown">
                    
                    <ul class="dropdown-menu">
                        <li class="header">Bildirimler</li>
                        <li class="body">
                            <ul class="menu">
                                
                        </li>
                    </ul>
                </li>
                <li class="footer">
                    <a href="javascript:void(0);">Tüm Bildirimleri Göster</a>
                </li>
                </ul>
                </li>
                <!-- #END# Tasks -->

                </ul>
            </div>

        </div>
    </nav>
    <!-- #Top Bar -->
    <section>
        <!-- Left Sidebar -->
        <aside id="leftsidebar" class="sidebar">
            <!-- User Info -->
            <div class="user-info">
                <div class="image">
                    <img src="/admin/images/user.png" width="48" height="48" alt="User" />
                </div>
                <div class="info-container">
                    <div class="name" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                        <?php echo e(Auth::user()->name); ?>

                    </div>
                    <div class="email"><?php echo e(Auth::user()->email); ?></div>
                    <div class="btn-group user-helper-dropdown">
                        <i class="material-icons" data-toggle="dropdown" aria-haspopup="true"
                            aria-expanded="true">keyboard_arrow_down</i>
                        <ul class="dropdown-menu pull-right">
                            <li><a href=""><i class="material-icons">person</i>Profil</a>
                            </li>
                            <li role="separator" class="divider"></li>

                            <li><a href="<?php echo e(route('logout')); ?>" onclick="event.preventDefault();
                                document.getElementById('logout-form').submit();"><i
                                        class="material-icons">input</i>Oturumu Kapat</a></li>


                            <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" style="display: none;">
                                <?php echo csrf_field(); ?>
                            </form>
                        </ul>
                    </div>
                </div>
            </div>
            <!-- #User Info -->
            <!-- Menu -->
            <div class="menu">
                <ul class="list">



                    <li class="header">ANA MENÜ</li>
                    <li class="<?php echo e(request()->is('yonetim') || request()->is('yonetim/anasayfa*') ? 'active' : ''); ?>">
                        <a href="">
                            <i class="material-icons col-green">home</i>
                            <span>Anasayfa</span>
                        </a>
                    </li>

                            <li class="">
                                <a class="menu-toggle">
                                    <i class="material-icons col-amber">widgets</i>
                                    <span>Servis Fişleri</span>
                                </a>
                                <ul class="ml-menu">
                                    <li class="">
                                        <a href="">
                                            <i class="material-icons col-amber">donut_large</i>
                                            <span>Yeni Servis Fişleri</span>
                                        </a>
                                    </li>
                                    <li class="">
                                        <a href="">
                                            <i class="material-icons col-amber">donut_large</i>
                                            <span>Hepsini Listele</span>
                                        </a>
                                    </li>
                                    <li class="">
                                        <a href="">
                                            <i class="material-icons col-amber">donut_large</i>
                                            <span>Durumlara Göre</span>
                                        </a>
                                    </li>
                                    <li class="">
                                        <a href="">
                                            <i class="material-icons col-amber">donut_large</i>
                                            <span>Bugün Eklenenler</span>
                                        </a>
                                    </li>
                                    <li class="">
                                        <a href="">
                                            <i class="material-icons col-amber">donut_large</i>
                                            <span>Benim Eklediklerim</span>
                                        </a>
                                    </li>
                                </ul>
                            </li>


                            <li class="">
                                <a class="menu-toggle">
                                    <i class="material-icons col-amber">widgets</i>
                                    <span>Cari Hesaplar</span>
                                </a>
                                <ul class="ml-menu">
                                    <li class="">
                                        <a href="">
                                            <i class="material-icons col-amber">donut_large</i>
                                            <span>Yeni Cari Hesap</span>
                                        </a>
                                    </li>
                                    <li class="">
                                        <a href="">
                                            <i class="material-icons col-amber">donut_large</i>
                                            <span>Hepsini Listele</span>
                                        </a>
                                    </li>
                                    <li class="">
                                        <a href="">
                                            <i class="material-icons col-amber">donut_large</i>
                                            <span>Borçlu Olanlar</span>
                                        </a>
                                    </li>
                                    <li class="">
                                        <a href="">
                                            <i class="material-icons col-amber">donut_large</i>
                                            <span>Alacaklı Olanlar</span>
                                        </a>
                                    </li>
                                    <li class="">
                                        <a href="">
                                            <i class="material-icons col-amber">donut_large</i>
                                            <span>Arama</span>
                                        </a>
                                    </li>
                                </ul>
                            </li>



                            <li class="">
                                <a class="menu-toggle">
                                    <i class="material-icons col-amber">widgets</i>
                                    <span>Yedek Parçalar</span>
                                </a>
                                <ul class="ml-menu">
                                    <li class="">
                                        <a href="">
                                            <i class="material-icons col-amber">donut_large</i>
                                            <span>Yedek Parça Ekle</span>
                                        </a>
                                    </li>
                                    <li class="">
                                        <a href="">
                                            <i class="material-icons col-amber">donut_large</i>
                                            <span>Hepsini Listele</span>
                                        </a>
                                    </li>
                                    <li class="">
                                        <a href="">
                                            <i class="material-icons col-amber">donut_large</i>
                                            <span>Eksi Stokta Olanlar</span>
                                        </a>
                                    </li>
                                    <li class="">
                                        <a href="">
                                            <i class="material-icons col-amber">donut_large</i>
                                            <span>Arama</span>
                                        </a>
                                    </li>
                                </ul>
                            </li>


                            <li class="">
                                <a class="menu-toggle">
                                    <i class="material-icons col-amber">widgets</i>
                                    <span>Kasa İşlemleri</span>
                                </a>
                                <ul class="ml-menu">
                                    <li class="">
                                        <a href="">
                                            <i class="material-icons col-amber">donut_large</i>
                                            <span>Gelir-Gider Ekle</span>
                                        </a>
                                    </li>
                                    <li class="">
                                        <a href="">
                                            <i class="material-icons col-amber">donut_large</i>
                                            <span>Tahsilatlar</span>
                                        </a>
                                    </li>
                                    <li class="">
                                        <a href="">
                                            <i class="material-icons col-amber">donut_large</i>
                                            <span>Ödemeler</span>
                                        </a>
                                    </li>
                                    <li class="">
                                        <a href="">
                                            <i class="material-icons col-amber">donut_large</i>
                                            <span>Hepsini Listele</span>
                                        </a>
                                    </li>
                                    <li class="">
                                        <a href="">
                                            <i class="material-icons col-amber">donut_large</i>
                                            <span>Benim İşlemlerim</span>
                                        </a>
                                    </li>
                                    <li class="">
                                        <a href="">
                                            <i class="material-icons col-amber">donut_large</i>
                                            <span>Arama</span>
                                        </a>
                                    </li>
                                </ul>
                            </li>


                            <li class="">
                                <a class="menu-toggle">
                                    <i class="material-icons col-amber">widgets</i>
                                    <span>Fatura / Alış / Satış</span>
                                </a>
                                <ul class="ml-menu">
                                    <li class="">
                                        <a href="">
                                            <i class="material-icons col-amber">donut_large</i>
                                            <span>Alış Faturası Ekle</span>
                                        </a>
                                    </li>
                                    <li class="">
                                        <a href="">
                                            <i class="material-icons col-amber">donut_large</i>
                                            <span>Alış Faturaları</span>
                                        </a>
                                    </li>
                                    <li class="">
                                        <a href="">
                                            <i class="material-icons col-amber">donut_large</i>
                                            <span>Satış Faturası Ekle</span>
                                        </a>
                                    </li>
                                    <li class="">
                                        <a href="">
                                            <i class="material-icons col-amber">donut_large</i>
                                            <span>Satış Faturaları</span>
                                        </a>
                                    </li>
                                </ul>
                            </li>


                            <li class="">
                                <a class="menu-toggle">
                                    <i class="material-icons col-amber">widgets</i>
                                    <span>Gelir Gider Fişleri</span>
                                </a>
                                <ul class="ml-menu">
                                    <li class="">
                                        <a href="">
                                            <i class="material-icons col-amber">donut_large</i>
                                            <span>Yeni Fiş Gir</span>
                                        </a>
                                    </li>
                                    <li class="">
                                        <a href="">
                                            <i class="material-icons col-amber">donut_large</i>
                                            <span>Gelir Fişleri</span>
                                        </a>
                                    </li>
                                    <li class="">
                                        <a href="">
                                            <i class="material-icons col-amber">donut_large</i>
                                            <span>Gider Fişleri</span>
                                        </a>
                                    </li>
                                    <li class="">
                                        <a href="">
                                            <i class="material-icons col-amber">donut_large</i>
                                            <span>Hepsini Listele</span>
                                        </a>
                                    </li>
                                    <li class="">
                                        <a href="">
                                            <i class="material-icons col-amber">donut_large</i>
                                            <span>Bugünün Fişleri</span>
                                        </a>
                                    </li>
                                    <li class="">
                                        <a href="">
                                            <i class="material-icons col-amber">donut_large</i>
                                            <span>Benim İşlemlerim</span>
                                        </a>
                                    </li>
                                    <li class="">
                                        <a href="">
                                            <i class="material-icons col-amber">donut_large</i>
                                            <span>Arama</span>
                                        </a>
                                    </li>
                                </ul>
                            </li>


                            <li class="">
                                <a class="menu-toggle">
                                    <i class="material-icons col-amber">widgets</i>
                                    <span>Veresiye Defteri</span>
                                </a>
                                <ul class="ml-menu">
                                    <li class="">
                                        <a href="">
                                            <i class="material-icons col-amber">donut_large</i>
                                            <span>Veresiye Ekle</span>
                                        </a>
                                    </li>
                                    <li class="">
                                        <a href="">
                                            <i class="material-icons col-amber">donut_large</i>
                                            <span>Hepsini Listele</span>
                                        </a>
                                    </li>
                                    <li class="">
                                        <a href="">
                                            <i class="material-icons col-amber">donut_large</i>
                                            <span>Bekleyenler</span>
                                        </a>
                                    </li>
                                    <li class="">
                                        <a href="">
                                            <i class="material-icons col-amber">donut_large</i>
                                            <span>Tahsil Edilenler</span>
                                        </a>
                                    </li>
                                    <li class="">
                                        <a href="">
                                            <i class="material-icons col-amber">donut_large</i>
                                            <span>Bugünkü Vadeler</span>
                                        </a>
                                    </li>
                                    <li class="">
                                        <a href="">
                                            <i class="material-icons col-amber">donut_large</i>
                                            <span>Arama</span>
                                        </a>
                                    </li>
                                </ul>
                            </li>


                            <li class="">
                                <a class="menu-toggle">
                                    <i class="material-icons col-amber">widgets</i>
                                    <span>Tanımlamalar</span>
                                </a>
                                <ul class="ml-menu">
                                    <li class="">
                                        <a href="">
                                            <i class="material-icons col-amber">donut_large</i>
                                            <span>Durumlar</span>
                                        </a>
                                    </li>
                                    <li class="">
                                        <a href="">
                                            <i class="material-icons col-amber">donut_large</i>
                                            <span>Cihazlar</span>
                                        </a>
                                    </li>
                                    <li class="">
                                        <a href="">
                                            <i class="material-icons col-amber">donut_large</i>
                                            <span>Markalar</span>
                                        </a>
                                    </li>
                                    <li class="">
                                        <a href="">
                                            <i class="material-icons col-amber">donut_large</i>
                                            <span>Yetki Grupları</span>
                                        </a>
                                    </li>
                                    <li class="">
                                        <a href="">
                                            <i class="material-icons col-amber">donut_large</i>
                                            <span>Gelir Gider Kartları</span>
                                        </a>
                                    </li>
                                    <li class="">
                                        <a href="">
                                            <i class="material-icons col-amber">donut_large</i>
                                            <span>Sms Şablonları</span>
                                        </a>
                                    </li>
                                    <li class="">
                                        <a href="">
                                            <i class="material-icons col-amber">donut_large</i>
                                            <span>Email Şablonları</span>
                                        </a>
                                    </li>
                                </ul>
                            </li>


                            <li class="">
                                <a class="menu-toggle">
                                    <i class="material-icons col-amber">widgets</i>
                                    <span>Personel İşlemleri</span>
                                </a>
                                <ul class="ml-menu">
                                    <li class="">
                                        <a href="">
                                            <i class="material-icons col-amber">donut_large</i>
                                            <span>Yeni Personel</span>
                                        </a>
                                    </li>
                                    <li class="">
                                        <a href="">
                                            <i class="material-icons col-amber">donut_large</i>
                                            <span>Hepsini Listele</span>
                                        </a>
                                    </li>
                                </ul>
                            </li>


                            <li class="">
                                <a class="menu-toggle">
                                    <i class="material-icons col-amber">widgets</i>
                                    <span>Hatırlatmalar</span>
                                </a>
                                <ul class="ml-menu">
                                    <li class="">
                                        <a href="">
                                            <i class="material-icons col-amber">donut_large</i>
                                            <span>Hatırlatma Ekle</span>
                                        </a>
                                    </li>
                                    <li class="">
                                        <a href="">
                                            <i class="material-icons col-amber">donut_large</i>
                                            <span>Bugün</span>
                                        </a>
                                    </li>
                                    <li class="">
                                        <a href="">
                                            <i class="material-icons col-amber">donut_large</i>
                                            <span>Geçmiş</span>
                                        </a>
                                    </li>
                                    <li class="">
                                        <a href="">
                                            <i class="material-icons col-amber">donut_large</i>
                                            <span>Benim Eklediklerim</span>
                                        </a>
                                    </li>
                                </ul>
                            </li>


                            <li class="">
                                <a class="menu-toggle">
                                    <i class="material-icons col-amber">widgets</i>
                                    <span>Aktarım İşlemleri</span>
                                </a>
                                <ul class="ml-menu">
                                    <li class="">
                                        <a href="">
                                            <i class="material-icons col-amber">donut_large</i>
                                            <span>Servis Fişleri</span>
                                        </a>
                                    </li>
                                    <li class="">
                                        <a href="">
                                            <i class="material-icons col-amber">donut_large</i>
                                            <span>Cari Hesaplar</span>
                                        </a>
                                    </li>
                                    <li class="">
                                        <a href="">
                                            <i class="material-icons col-amber">donut_large</i>
                                            <span>Stok Aktarım</span>
                                        </a>
                                    </li>
                                </ul>
                            </li>


                            <li class="">
                                <a class="menu-toggle">
                                    <i class="material-icons col-amber">widgets</i>
                                    <span>Raporlar</span>
                                </a>
                                <ul class="ml-menu">
                                    <li class="">
                                        <a href="">
                                            <i class="material-icons col-amber">donut_large</i>
                                            <span>Cari Hareketleri</span>
                                        </a>
                                    </li>
                                    <li class="">
                                        <a href="">
                                            <i class="material-icons col-amber">donut_large</i>
                                            <span>Kasa Raporu</span>
                                        </a>
                                    </li>
                                    <li class="">
                                        <a href="">
                                            <i class="material-icons col-amber">donut_large</i>
                                            <span>Kasa Hareketleri</span>
                                        </a>
                                    </li>
                                    <li class="">
                                        <a href="">
                                            <i class="material-icons col-amber">donut_large</i>
                                            <span>Kar Zarar</span>
                                        </a>
                                    </li>
                                    <li class="">
                                        <a href="">
                                            <i class="material-icons col-amber">donut_large</i>
                                            <span>Yoğunluk Analizi</span>
                                        </a>
                                    </li>
                                    <li class="">
                                        <a href="">
                                            <i class="material-icons col-amber">donut_large</i>
                                            <span>Günlük Alış Satış</span>
                                        </a>
                                    </li>
                                    <li class="">
                                        <a href="">
                                            <i class="material-icons col-amber">donut_large</i>
                                            <span>Stok Hareketleri</span>
                                        </a>
                                    </li>
                                </ul>
                            </li>


                            <li class="">
                                <a class="menu-toggle">
                                    <i class="material-icons col-amber">widgets</i>
                                    <span>Ayarlar</span>
                                </a>
                                <ul class="ml-menu">
                                    <li class="">
                                        <a href="">
                                            <i class="material-icons col-amber">donut_large</i>
                                            <span>Genel Ayarlar</span>
                                        </a>
                                    </li>
                                    <li class="">
                                        <a href="">
                                            <i class="material-icons col-amber">donut_large</i>
                                            <span>Sms / Email Ayarları</span>
                                        </a>
                                    </li>
                                    <li class="">
                                        <a href="">
                                            <i class="material-icons col-amber">donut_large</i>
                                            <span>Firma Bilgileri</span>
                                        </a>
                                    </li>
                                </ul>
                            </li>


                            





                    

                </ul>
            </div>
            <!-- #Menu -->
            <!-- Footer -->
            <div class="legal">
                <div class="copyright">
                    &copy; 2019 <a href="javascript:void(0);">Mücahid Keleş</a>.
                </div>
                <div class="version">
                    <b>Ver: </b> 1.0.0
                </div>
            </div>
            <!-- #Footer -->
        </aside>
        <!-- #END# Left Sidebar -->
        <!-- Right Sidebar -->
        <aside id="rightsidebar" class="right-sidebar">
            <ul class="nav nav-tabs tab-nav-right" role="tablist">
                <li role="presentation" class="active"><a href="#skins" data-toggle="tab">TEMALAR</a></li>
                <li role="presentation"><a href="#settings" data-toggle="tab">AYARLAR</a></li>
            </ul>
            <div class="tab-content">
                <div role="tabpanel" class="tab-pane fade in active in active" id="skins">
                    <ul class="demo-choose-skin">
                        <li data-theme="red" class="active">
                            <div class="red"></div>
                            <span>Red</span>
                        </li>
                        <li data-theme="pink">
                            <div class="pink"></div>
                            <span>Pink</span>
                        </li>
                        <li data-theme="purple">
                            <div class="purple"></div>
                            <span>Purple</span>
                        </li>
                        <li data-theme="deep-purple">
                            <div class="deep-purple"></div>
                            <span>Deep Purple</span>
                        </li>
                        <li data-theme="indigo">
                            <div class="indigo"></div>
                            <span>Indigo</span>
                        </li>
                        <li data-theme="blue">
                            <div class="blue"></div>
                            <span>Blue</span>
                        </li>
                        <li data-theme="light-blue">
                            <div class="light-blue"></div>
                            <span>Light Blue</span>
                        </li>
                        <li data-theme="cyan">
                            <div class="cyan"></div>
                            <span>Cyan</span>
                        </li>
                        <li data-theme="teal">
                            <div class="teal"></div>
                            <span>Teal</span>
                        </li>
                        <li data-theme="green">
                            <div class="green"></div>
                            <span>Green</span>
                        </li>
                        <li data-theme="light-green">
                            <div class="light-green"></div>
                            <span>Light Green</span>
                        </li>
                        <li data-theme="lime">
                            <div class="lime"></div>
                            <span>Lime</span>
                        </li>
                        <li data-theme="yellow">
                            <div class="yellow"></div>
                            <span>Yellow</span>
                        </li>
                        <li data-theme="amber">
                            <div class="amber"></div>
                            <span>Amber</span>
                        </li>
                        <li data-theme="orange">
                            <div class="orange"></div>
                            <span>Orange</span>
                        </li>
                        <li data-theme="deep-orange">
                            <div class="deep-orange"></div>
                            <span>Deep Orange</span>
                        </li>
                        <li data-theme="brown">
                            <div class="brown"></div>
                            <span>Brown</span>
                        </li>
                        <li data-theme="grey">
                            <div class="grey"></div>
                            <span>Grey</span>
                        </li>
                        <li data-theme="blue-grey">
                            <div class="blue-grey"></div>
                            <span>Blue Grey</span>
                        </li>
                        <li data-theme="black">
                            <div class="black"></div>
                            <span>Black</span>
                        </li>
                    </ul>
                </div>
                <div role="tabpanel" class="tab-pane fade" id="settings">
                    <div class="demo-settings">
                        <p>GENEL AYARLAR</p>
                        <ul class="setting-list">
                            <li>
                                <span>Report Panel Usage</span>
                                <div class="switch">
                                    <label><input type="checkbox" checked><span class="lever"></span></label>
                                </div>
                            </li>
                            <li>
                                <span>Email Redirect</span>
                                <div class="switch">
                                    <label><input type="checkbox"><span class="lever"></span></label>
                                </div>
                            </li>
                        </ul>
                        <p>SİSTEM AYARLARI</p>
                        <ul class="setting-list">
                            <li>
                                <span>Notifications</span>
                                <div class="switch">
                                    <label><input type="checkbox" checked><span class="lever"></span></label>
                                </div>
                            </li>
                            <li>
                                <span>Auto Updates</span>
                                <div class="switch">
                                    <label><input type="checkbox" checked><span class="lever"></span></label>
                                </div>
                            </li>
                        </ul>
                        <p>ACCOUNT SETTINGS</p>
                        <ul class="setting-list">
                            <li>
                                <span>Offline</span>
                                <div class="switch">
                                    <label><input type="checkbox"><span class="lever"></span></label>
                                </div>
                            </li>
                            <li>
                                <span>Location Permission</span>
                                <div class="switch">
                                    <label><input type="checkbox" checked><span class="lever"></span></label>
                                </div>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </aside>
        <!-- #END# Right Sidebar -->
    </section>
    <?php echo $__env->yieldContent('modal'); ?>
    <?php echo $__env->yieldContent('icerik'); ?>





    <!-- Jquery Core Js -->
    <script src="/admin/plugins/jquery/jquery.min.js"></script>




    <!-- Select Plugin Js -->
    <script src="/admin/plugins/bootstrap-select/js/bootstrap-select.js"></script>
    <!-- Select Plugin Js -->
    <script src="/admin/plugins/bootstrap-select/js/bootstrap-select.min.js"></script>


    <?php echo $__env->yieldContent('js'); ?>




    <!-- Slimscroll Plugin Js -->
    <script src="/admin/plugins/jquery-slimscroll/jquery.slimscroll.js"></script>

    <!-- Waves Effect Plugin Js -->
    <script src="/admin/plugins/node-waves/waves.js"></script>

    <script src="/admin/toastr.min.js"></script>

    <!-- Custom Js -->
    <script src="/admin/js/admin.js"></script>

    <!-- Bootstrap Core Js -->
    <script src="/admin/plugins/bootstrap/js/bootstrap.js"></script>




    




</body>

</html>
<?php /**PATH C:\xampp\htdocs\laravel\takip\resources\views/admin/template.blade.php ENDPATH**/ ?>