<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTahsilatlarTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('tahsilatlar', function (Blueprint $table) {
            $table->increments('id');

            $table->integer('servis_fisi_tutar');
            $table->integer('iskonto');
            $table->integer('odeme_tutari');

            $table->integer('cari_id')->unsigned();
            $table->integer('servis_fisi_id')->unsigned();

            $table->timestamps();


            $table->foreign('cari_id')->references('id')->on('cari')->ondelete('cascade');
            $table->foreign('servis_fisi_id')->references('id')->on('servis_fisi')->ondelete('cascade');


        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('tahsilatlar');
    }
}
