@extends('admin.template')
@section('icerik')
<div class="card-body">
    <div class="row">

        @foreach ($durumlar as $durum)
        <!-- kutu -->
        <div class="col-md-2" onclick="window.location='{{ route('home.servis_fisi.filtrele',$durum->id) }}';">
          <!-- small box -->
          <div class="small-box ">
            <div class="inner" style="background-color:{{ $durum->renk }};border-radius: 10px;">
             <font style="color:white">
                <h3>{{ $durum->sayi($durum->id) }}</h3>
                <p>{{ $durum->isim }}</p>
            </font>
            </div>
          </div>
        </div>
        <!-- kutu -->

        @endforeach

        <div class="col-lg-12">
            <div class="card card-primary">
                <div class="card-body">

                    <div class="form-group ">

                        <table id="example" class="table table-bordered table-striped dataTable" role="grid" aria-describedby="example1_info">
                            <thead>
                                <th style="width: 5%">#</th>
                                <th style="width: 20%">Cari Hesap</th>
                                <th style="width: 15%">Arıza</th>
                                <th style="width: 8%">Ürün</th>
                                <th style="width: 15%">Durum</th>
                                <th style="width: 5%">Garanti</th>
                                <th style="width: 5%">Bakiye</th>
                                <th style="width: 10%">Tarih</th>
                                <th style="width: 11%">İşlemler</th>
                            </thead>
                            <tbody>
                                @foreach ($servisfisleri as $servisfisi)
                                @if($servisfisi->bakiye($servisfisi->id) >0)
                                <tr>
                                    <td >{{ $servisfisi->id }}</td>
                                    <td ><a title="{{ $servisfisi->cari->isim }}" >{{ \Illuminate\Support\Str::limit($servisfisi->cari->isim, $limit = 30, $end = '...') }}</a></td>
                                    <td ><a title="{{ $servisfisi->ariza }}" >{{ \Illuminate\Support\Str::limit($servisfisi->ariza, $limit = 20, $end = '...') }}</a></td>
                                    <td >{{ $servisfisi->urun->isim }}</td>
                                    <td ><b><label style="color:{{ $servisfisi->durum->renk }}" title="{{  $servisfisi->durum_aciklama  }}">{{ $servisfisi->durum->isim }}</label></b></td>
                                    <td >{{ $servisfisi->garanti }}</td>
                                    <td >{{ $servisfisi->bakiye($servisfisi->id)}}</td>
                                    <td >{{ $servisfisi->created_at->format('d/m/Y') }}</td>
                                    <td >
                                        <div class="btn-group">
                                            <button type="button" class="btn btn-secondary btn-sm dropdown-toggle" data-toggle="dropdown" aria-expanded="false">
                                              <i class="fas fa-print"></i></button>
                                            <div class="dropdown-menu float-right" role="menu" x-placement="bottom-start" style="position: absolute; will-change: transform; top: 0px; left: 0px; transform: translate3d(0px, 31px, 0px);">
                                              <a target="_blank" href="{{ route('home.form.kabul',$servisfisi->id) }}" class="dropdown-item">Kabul Formu</a>
                                              <a target="_blank" href="{{ route('home.form.teslim',$servisfisi->id) }}" class="dropdown-item">Teslim Formu</a>
                                            </div>
                                          </div>


                                        <button title="Tahsilat Yap"  class='show-modal btn btn-info btn-sm tahsilat'
                                        data-id="{{ $servisfisi->id }}"
                                        data-cari_id="{{ $servisfisi->cari_id }}"
                                        data-toggle="modal" data-target="#tahsilat" ><span class='fa fa-cash-register'></span></button>

                                        <a title="Düzenle" href="{{ route('home.servis_fisi.duzenle',$servisfisi->id) }}" class='show-modal btn btn-primary btn-sm' ><span class='fa fa-edit'></span></a>

                                        <button title="Sms Gönder"  class='show-modal btn btn-success btn-sm sms_sablonu'
                                        data-cari_id1="{{ $servisfisi->cari_id }}"

                                        data-toggle="modal" data-target="#sms_sablonu" ><span class='fas fa-sms'></span></button>


                                    </td>
                                </tr>
                                @endif

                                @endforeach
                            </tbody>
                        </table>
                        <?php echo $servisfisleri->render(); ?>
                    </div>
                </div>
            </div>
        </div>
      </div>
      {{-- Tahsilat Modal --}}
<div id="tahsilat" class="modal fade" role="dialog">
    <form method="POST" action="{{ route('home.servis_fisi.tahsilatyap')}}">
        {{ csrf_field() }}
    <div class="modal-dialog">
      <div class="modal-content">
        <div class="modal-body">

            <div class="form-group row add">
              <label class="control-label col-sm-4" for="title"><b>İskonto:</b></label>
              <div class="col-sm-6">
                <input type="text" class="form-control" id="iskonto" name="iskonto" value="0" required>
                <input type="text" class="form-control" id="id" name="id" hidden required>
                <input type="text" class="form-control" id="cari_id" name="cari_id" hidden required>
              </div>
              </div>

              <div class="form-group row add">
                <label class="control-label col-sm-4" for="title"><b>Ödeme Tutarı:</b></label>
                <div class="col-sm-6">
                  <input type="text" class="form-control" id="odeme_tutari" name="odeme_tutari" required>

                </div>
                </div>


        </div>
            <div class="modal-footer">
              <button class="btn btn-success" type="submit" id="add">
                <span class="glyphicon glyphicon-plus"></span>Tahsilat Yap
              </button>
              <button class="btn btn-danger" type="button" data-dismiss="modal">
                <span class="glyphicon glyphicon-remobe"></span>Kapat
              </button>
            </div>
      </div>
    </div>
</form>
  </div>
  {{-- Tahsilat Modal --}}

  {{-- Sms Gönder Modal --}}
<div id="sms_sablonu" class="modal fade" role="dialog">
    <form method="POST" action="{{ route('home.sms.gonder')}}">
        {{ csrf_field() }}
    <div class="modal-dialog">
      <div class="modal-content">
        <div class="modal-body">

              <div class="form-group row add">
                <label class="control-label col-sm-4" for="title"><b>SMS Şablonu:</b></label>
                <div class="col-sm-8">
                  <select name="sms_sablon" id="sms_sablon" class="sms_sablon form-control">
                    <option value="">Seçiniz</option>
                      @foreach ($sms_sablonlari as $sablon)
                          <option value={{ $sablon->id }}>{{ $sablon->isim }}</option>
                      @endforeach
                  </select>
                  <input type="text" class="cari_id1 form-control" id="cari_id1" name="cari_id1" hidden  required>

                </div>
              </div>

              <div class="form-group row add">

                  <div id="sms_mesaj"  class="col-md-12">

                  </div>
              </div>
        </div>
            <div class="modal-footer">
              <button class="btn btn-success" type="submit" id="add">
                <span class="glyphicon glyphicon-plus"></span>Gönder
              </button>
              <button class="btn btn-danger" type="button" data-dismiss="modal">
                <span class="glyphicon glyphicon-remobe"></span>Kapat
              </button>
            </div>
      </div>
    </div>
</form>
  </div>
  {{-- Sms Gönder Modal --}}
  </div>

@endsection

@section('css')
  <!-- DataTables -->



  <!-- DataTables -->
  <link rel="stylesheet" href="/yonetim/plugins/datatables-bs4/css/dataTables.bootstrap4.css">

@endsection

@section('js')
<!-- DataTables -->
<script src="/yonetim/plugins/datatables/jquery.dataTables.js"></script>
<script src="/yonetim/plugins/datatables-bs4/js/dataTables.bootstrap4.js"></script>





<script>
    $(function () {

      $('#example').DataTable({
        "paging": true,
        "lengthChange": true,
        "searching": true,
        "ordering": true,
        "info": true,
        "autoWidth": false,

                    "language":{
                        "sDecimal":        ",",
                        "sEmptyTable":     "Tabloda herhangi bir veri mevcut değil",
                        "sInfo":           "_TOTAL_ kayıttan _START_ - _END_ arasındaki kayıtlar gösteriliyor",
                        "sInfoEmpty":      "Kayıt yok",
                        "sInfoFiltered":   "(_MAX_ kayıt içerisinden bulunan)",
                        "sInfoPostFix":    "",
                        "sInfoThousands":  ".",
                        "sLengthMenu":     "Sayfada _MENU_ kayıt göster",
                        "sLoadingRecords": "Yükleniyor...",
                        "sProcessing":     "İşleniyor...",
                        "sSearch":         "Ara:",
                        "sZeroRecords":    "Eşleşen kayıt bulunamadı",
                        "oPaginate": {
                            "sFirst":    "İlk",
                            "sLast":     "Son",
                            "sNext":     "Sonraki",
                            "sPrevious": "Önceki"
                        },
                        "oAria": {
                            "sSortAscending":  ": artan sütun sıralamasını aktifleştir",
                            "sSortDescending": ": azalan sütun sıralamasını aktifleştir"
                        },
                        "select": {
                            "rows": {
                                "_": "%d kayıt seçildi",
                                "0": "",
                                "1": "1 kayıt seçildi"
                            }
                        }
                    }
      });
    });
  </script>

  <!-- sablon Getir Script -->
<script type="text/javascript">
    $(document).on('change','.sms_sablon',function () {
    var sms_sablon_id=$(this).val();

    var a=$(this).parent();
    console.log(sms_sablon_id);
    var op="";
    $.ajax({
        type:'get',
        url:'{!!URL::to('sms_sablon_getir')!!}',
        data:{'id':sms_sablon_id},
        dataType:'json',
        success:function(data){
            console.log(data.mesaj);
            $("#sms_mesaj").html("<div class=''><textarea  name='sms_mesaj' class='sms_mesaj form-control'  >"+data.mesaj+"</textarea></div>");

          //$("#sms_mesaj").html("<div class=''><input type='text' name='sms_mesaj' class='sms_mesaj form-control' value="+data.mesaj+" ></div>");

            // a.find('.fiyat').val(data.satis_fiyati);

        },
        error:function(){

        }
    });
});
</script>
<!-- sablon Getir Script -->

@endsection

