<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateServisFisiTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('servis_fisi', function (Blueprint $table) {
            $table->increments('id');

            $table->string('seri');
            $table->string('model')->nullable();
            $table->string('teslim_tarihi')->nullable();
            $table->longtext('ariza');
            $table->longtext('aciklama')->nullable();
            $table->longtext('birlikte_gelenler')->nullable();
            $table->string('garanti');
            $table->string('durum_aciklama')->nullable();
            $table->integer('personel')->nullable();


            $table->integer('cari_id')->unsigned();
            $table->integer('marka_id')->unsigned();
            $table->integer('urun_id')->unsigned();
            $table->integer('durum_id')->unsigned();


            $table->timestamps();

            $table->foreign('cari_id')->references('id')->on('cari')->ondelete('cascade');
            $table->foreign('marka_id')->references('id')->on('markalar')->ondelete('cascade');
            $table->foreign('urun_id')->references('id')->on('urunler')->ondelete('cascade');
            $table->foreign('durum_id')->references('id')->on('durumlar')->ondelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('servis_fisi');
    }
}
